---
title: Set up a site · Cloudflare One docs
description: Sites represent the local network of a data center, office, or
  other physical location, and combine all on-ramps available there. Sites also
  allow you to check, at a glance, the state of your on-ramps and set up health
  alert settings so that you get notified when there are issues with the site's
  on-ramps.
lastUpdated: 2025-11-04T17:07:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/common-settings/sites/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/common-settings/sites/index.md
---

Sites represent the local network of a data center, office, or other physical location, and combine all on-ramps available there. Sites also allow you to check, at a glance, the state of your on-ramps and set up health alert settings so that you get notified when there are issues with the site's on-ramps.

To use a site, start by setting up your on-ramps. On-ramps can be:

* [GRE or IPsec tunnels](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/how-to/configure-tunnel-endpoints/)
* [Magic WAN Connector](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/)
* Direct [CNI link](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/network-interconnect/)

When you are finished setting these up, refer to the steps below to learn how to set up a site.

## Add a site

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/).
2. Go to **Insights** > **Network visibility**.
3. In **Network overview**, select **Add site**.

1) Add a name and description for your new site. Optionally, you can also add the geographical coordinates for your site in **Latitude** and **Longitude**. If you add geographical coordinates, once created your site's location will show in the map.
2) Select **Create and continue**.
3) Choose one or more on-ramps for your site from the list. Remember to only choose the on-ramps available to that particular site, as the list might show on-ramps available on other locations.
4) Select **Continue**.
5) In **Define alert settings** you set up alerts to notify you when there are issues with your site's on-ramps. If you want to set up alerts later, select **Skip this for now** to complete your setup. Otherwise, continue reading.
6) In **Magic WAN Health Check Alert** > **Notification name**, enter a name for the site's alert.
7) Under **Alert settings**, choose how you want to be notified when there is an issue. You can add webhooks as well as email addresses.
8) In **Alert sensitivity level** define the threshold for Magic Tunnel health alerts to be fired. Refer to [How Cloudflare calculates Magic Tunnel health alerts](https://developers.cloudflare.com/magic-wan/reference/how-cloudflare-calculates-magic-tunnel-health-alerts/) for more information.
9) Select **Complete setup** to finish setting up your site.

Your site is now set up. If you have other sites you need to set up, repeat the steps above. If you did not set up alerts, we strongly recommend that you do it. Otherwise you will not be notified when there is a problem with one of your on-ramps.

***

## Site analytics

After adding your sites, the Network visibility section of the dashboard provides a summary of the connectivity status and traffic analytics for all your sites. This is a great place to start if you receive a Magic WAN alert, need to begin the troubleshooting process, or are performing routine monitoring.

Network visibility has the following data types available:

Geographic map summary

* [Aggregate Magic WAN site health](#site-health)
* [Magic WAN availability status for sites](#no-status-available)
* [Magic WAN site geographic location](#no-location-set)

Magic WAN site data table

* Site Name
* Site Health
* Site Tunnel Names
* Site Tunnel Statuses
* Site Traffic Sent
* Site Traffic Received

Magic WAN site data

* Traffic Sent by Tunnel
* Traffic Received by Tunnel

To start using Magic WAN site analytics:

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/).
2. Go to **Insights** > **Network visibility**.

You will have access to an overview map with all your active sites, and any alerts for sites that are unhealthy or have no status available to them.

Review the topics below to learn more about the options available to you.

### Network map and traffic overview

The network map section shows all the sites configured with Magic WAN. At a glance, you can check:

* How many active sites you have
* Location for sites in a map (if you set up their geographic location)
* Sites that are healthy or unhealthy
* Sites that have no status available
* Sites that have no location set

Just below the map, Traffic overview shows a more granular list of your sites and their status.

#### Site health

Sites can be healthy or unhealthy, and Magic WAN uses this information to route traffic. Refer to [Set thresholds for site health](#set-thresholds-for-site-health) to learn more about this topic.

#### No status available

The status of a site refers to its health. If your sites show a **No status available** message, this means you did not configure your alert settings when creating your site. Refer to [Configure Magic Tunnel health alerts](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/common-settings/configure-magic-tunnel-health-alerts/) to learn how to create an alert for your site.

#### No location set

The dashboard shows you the number of sites with no location set, meaning sites for which you did not set up a geographic location. To add a location to a site, find the site you want to add location to, and select **no location set** to edit its location settings. Refer to [Set geographic coordinates](#set-geographic-coordinates) for more information.

### Traffic overview

Traffic overview aggregates all Magic WAN sites configured in your account. Here, you can check at-a-glance information about each site like:

* Site status
* Traffic sent and received

Select one of your sites to have access to a more detailed view of its traffic, including traffic by tunnel.

***

## Edit a site

### Add or remove on-ramps

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/).
2. Go to **Insights** > **Network visibility**.
3. In **Network overview** > **Traffic overview**, find your site > select the three dots in front of it > **Edit**.

1) Select **On-ramps**.
2) Select **Add** to add a new on-ramp.
3) If you want to remove an on-ramp, select the three dots in front of your on-ramp > **Remove**.

### Set geographic coordinates

If you add geographic coordinates to your site, it will show up in the Network map. To set up or edit geographic coordinates to an existing site:

1. Go to **Insights** > **Network visibility**.
2. In **Network overview** > **Traffic overview**, find your site > select the three dots in front of it > **Edit**.

1) In **Basic information**, edit your site's **Latitude** and **Longitude** coordinates.
2) Select **Save**.

### Set thresholds for site health

When you set up an alert for your site, you will be notified when there is an issue with one or more on-ramps. These alerts are sent when the percentage of successful health checks for a Magic WAN on-ramp drops below the selected service-level objective (SLO). Setting health alerts will also show unhealthy tunnels in the Network map and in the Traffic overview sections.

To set up health alerts:

1. Configure [Magic Tunnel health alerts](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/common-settings/configure-magic-tunnel-health-alerts/) across all of the Magic Tunnels associated with each Magic WAN site.
2. After configuring Magic Tunnel health alerts, any Magic WAN site with a Magic Tunnel (on-ramp) that is outside of its SLO threshold will be labeled unhealthy in Network map and Traffic overview.
