---
title: General FAQ · Cloudflare DNS docs
description: "Yes. Cloudflare offers free DNS services to customers on all
  plans. Note that:"
lastUpdated: 2025-09-12T14:57:41.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/troubleshooting/faq/
  md: https://developers.cloudflare.com/dns/troubleshooting/faq/index.md
---

## Is Cloudflare a free DNS (domain nameserver) provider?

Yes. Cloudflare offers [free DNS services](https://www.cloudflare.com/dns) to customers on all plans. Note that:

1. You do not need to change your hosting provider to use Cloudflare.
2. You do not need to move away from your registrar. The only change you make with your registrar is to point the authoritative nameservers to the Cloudflare nameservers.

***

## Does Cloudflare charge for or limit DNS queries?

Cloudflare never limits or caps DNS queries, but the pricing depends on your plan level.

For customers on Free, Pro, or Business plans, Cloudflare does not charge for DNS queries.

For customers on Enterprise plans, Cloudflare uses the number of monthly DNS queries as a pricing input to generate a custom quote.

***

## Where do I change my nameservers to point to Cloudflare?

Make the change at your registrar, which is where you registered your domain. This may or may not be your hosting provider. If you don't know who your registrar is for the domain, you can find this by doing a WHOIS search. You can use [ICANN Lookup](https://lookup.icann.org/), for example.

Warning

Some country code TLDs may not be supported by ICANN Lookup. If that is the case, use a different WHOIS search tool.

Once you identify your registrar, follow the instructions in [change nameservers to Cloudflare](https://developers.cloudflare.com/dns/zone-setups/full-setup/setup/#update-your-nameservers).

***

## Does Cloudflare limit the number of DNS records a domain can have?

Yes. All customers have a limit on the number of DNS records they can create.

* Free: 200
* Pro: 3,500
* Business: 3,500
* Enterprise: 3,500

Free zones created before 2024-09-01 00:00:00 UTC have an increased limit of 1,000.

For more DNS records

If you are an Enterprise customer and require more DNS records, contact your account team. Cloudflare can support millions of DNS records on a single zone.

***

## Which record types can Cloudflare proxy?

Only `A`, `AAAA`, and `CNAME` records can be proxied. Cloudflare will not proxy any other [DNS record types](https://developers.cloudflare.com/dns/manage-dns-records/reference/dns-record-types/).

***

## How do I add ANAME records on Cloudflare?

ANAME or ALIAS are DNS records used by specific DNS providers. If your previous provider was using ANAME or ALIAS, you can recreate these records on Cloudflare as CNAME records. Cloudflare's [CNAME flattening](https://developers.cloudflare.com/dns/cname-flattening/)[1](#user-content-fn-1) allows you to create CNAME records at your [zone apex](https://developers.cloudflare.com/dns/concepts/#zone-apex), removing the need for those other record types.

## Footnotes

1. A process in which Cloudflare returns an IP address instead of the target hostname that a CNAME record points to. [↩](#user-content-fnref-1)

***

## Can I CNAME a domain not on Cloudflare to a domain that is on Cloudflare?

No. If you would like to do a redirect for a site not on Cloudflare, then set up a traditional `301` or `302` redirect on your origin web server.

Redirecting non-Cloudflare sites via `CNAME` records would cause a DNS resolution error. Since Cloudflare is a reverse proxy for the domain that is on Cloudflare, the `CNAME` redirect for the domain (not on Cloudflare) would not know where to send the traffic to.

***

## Does Cloudflare support wildcard DNS entries?

Cloudflare supports wildcard '\*' DNS records, both proxied and unproxied, on all plans.

***

## How long does it take for a DNS change I made to push out?

By default, any changes or additions you make to your Cloudflare zone file will take effect globally within 5 minutes, usually much less.

Depending on the Time-to-Live (TTL) set on the previous [DNS record](https://developers.cloudflare.com/dns/manage-dns-records/how-to/create-dns-records/), old data may still remain cached until the TTL expires. Proxied records expire after 5 minutes ("Automatic"), but the TTL for unproxied records can be customized.

If changes to records with large TTLs are anticipated, it may make sense to reduce the TTL ahead of time so that the change takes effect as quickly as possible.

***

## Does Cloudflare offer domain masking?

No. Cloudflare does not offer domain masking or DNS redirect services (your hosting provider might). However, we do offer URL forwarding through [Bulk Redirects](https://developers.cloudflare.com/rules/url-forwarding/bulk-redirects/).

***

## Why can't I make ANY queries to Cloudflare DNS servers?

`ANY` queries are special and often misunderstood. They are usually used to get all record types available on a DNS name, but what they return is just any type in the cache of recursive resolvers. This can cause confusion when they are used for debugging.

Because of Cloudflare's many advanced DNS features like CNAME flattening, it can be complex and even impossible to give correct answers to `ANY` queries. For example, when DNS records dynamically come and go or are stored remotely, it can be taxing or even impossible to get all the results at the same time.

`ANY` is rarely used in production, but is often used in DNS reflection attacks, taking advantage of the lengthy answer returned by `ANY`.

Instead of using `ANY` queries to list records, Cloudflare customers can get a better overview of their DNS records by logging in and checking their DNS app settings.

The decision to block `ANY` queries was implemented for all Authoritative DNS customers in September 2015, and does not affect DNS Firewall customers.

Read [Deprecating the DNS ANY meta-query type](https://blog.cloudflare.com/deprecating-dns-any-meta-query-type/) on the Cloudflare blog.

***

## Why do I have to remove my `DS` record when signing up for Cloudflare?

Provider-specific instructions

This is not an exhaustive list of how to update DS records in other providers, but the following links may be helpful:

* [DNSimple](https://support.dnsimple.com/articles/cloudflare-ds-record/)
* [Domaindiscount24](https://support.domaindiscount24.com/hc/articles/4409759478161)
* [DreamHost](https://help.dreamhost.com/hc/en-us/articles/219539467)
* [Dynadot](https://www.dynadot.com/community/help/question/set-DNSSEC)
* [Enom](https://help.enom.com/hc/en-us/articles/115001028212)
* [Gandi](https://wiki.gandi.net/en/domains/dnssec)
* [GoDaddy](https://ph.godaddy.com/help/add-a-ds-record-23865)
* [Hostinger](https://support.hostinger.com/articles/3667267)
* [Hover](https://help.hover.com/hc/en-us/articles/217281647)
* [InMotion Hosting](https://www.inmotionhosting.com/support/edu/cpanel/enable-dnssec-cloudflare/)
* [INWX](https://kb.inwx.com/en-us/3-nameserver/131)
* [Joker.com](https://joker.com/faq/books/jokercom-faq-en/page/dnssec)
* [Name.com](https://www.name.com/support/articles/205439058-managing-dnssec)
* [Namecheap](https://www.namecheap.com/support/knowledgebase/article.aspx/9722/2232/managing-dnssec-for-domains-pointed-to-custom-dns)
* [NameISP](https://support.nameisp.com/answers/dns)
* [Namesilo](https://www.namesilo.com/Support/DS-Records-%28DNSSEC%29)
* [OVH](https://help.ovhcloud.com/csm/en-dns-secure-domain-dnssec?id=kb_article_view\&sysparm_article=KB0051637)
* [Squarespace](https://support.squarespace.com/hc/articles/4404183898125-Nameservers-and-DNSSEC-for-Squarespace-managed-domains#toc-dnssec)
* [Registro.br](https://registro.br/tecnologia/dnssec.html?secao=tutoriais-dns)
* [Porkbun](https://kb.porkbun.com/article/93-how-to-install-dnssec) (do not fill out **keyData**)
* [TransIP](https://www.transip.eu/knowledgebase/entry/150-secure-domains-custom-nameservers-dnssec/)

For more help, refer to [Enabling DNSSEC in Cloudflare](https://developers.cloudflare.com/dns/dnssec/).

***

## What happens when I remove the `DS` record?

When you remove your DS record, an invalidation process begins which results in the unsigning of your domain’s DNS records. This will allow your authoritative nameservers to be changed. If you are an existing customer, this will not affect your ability to use Cloudflare. New customers will need to complete this step before Cloudflare can be used successfully.

***

## Does Cloudflare support EDNS0 (extension mechanisms for DNS)?

Yes, Cloudflare DNS supports EDNS0. EDNS0 is enabled for all Cloudflare customers. It is a building block for modern DNS implementations that adds support for signaling if the DNS Resolver (recursive DNS provider) supports larger message sizes and DNSSEC.

EDNS0 is the first approved set of mechanisms for [DNS extensions](http://en.wikipedia.org/wiki/Extension_mechanisms_for_DNS), originally published as [RFC 2671](https://datatracker.ietf.org/doc/html/rfc2671).

***

## What should I do if I change my server IP address or hosting provider?

After switching hosting providers or server IP addresses, update the IP addresses in your Cloudflare **DNS** app. Your new hosting provider will provide the new IP addresses that your DNS should use.  To modify DNS record content in the **DNS** app, click on the IP address, and enter the new IP address.

***

## Where can I find my Cloudflare nameservers?

Under the **DNS** app of your Cloudflare account, review the **Cloudflare Nameservers**.

The IP address associated with a specific Cloudflare nameserver can be retrieved via a dig command or a third-party DNS lookup tool hosted online such as [whatsmydns.net](https://www.whatsmydns.net/):

```sh
dig kate.ns.cloudflare.com
```

```sh
kate.ns.cloudflare.com.    68675    IN    A    173.245.58.124.
```

***

## Why are Cloudflare's A or AAAA records / IP addresses for my domain's DNS responses appearing?

For DNS records proxied to Cloudflare, Cloudflare's IP addresses are returned in DNS queries instead of your original server IP address. This allows Cloudflare to optimize, cache, and protect all requests for your website.

***

## Can subdomains be added directly to Cloudflare?

Only Enterprise customers can add subdomains directly to Cloudflare via [Subdomain Support](https://developers.cloudflare.com/dns/zone-setups/subdomain-setup/).

***

## 403 Authentication error when creating DNS records using Terraform

**Problem Description**

`Error: failed to create DNS record: HTTP status 403: Authentication error (10000)` is returned when using Terraform with Cloudflare API.

**Root Cause**

Error seems to be misleading, as the error was found to be in customer code syntax, specifically: zone\_id = data.cloudflare\_zones.example\_com.id

**Solution**

Make sure the argument `zone_id = data.cloudflare_zones.example_com.zones[0].id`. A more detailed use case can be found in [this](https://github.com/cloudflare/terraform-provider-cloudflare/issues/913) GitHub thread.

***

## Why am I getting hundreds of random DNS records after adding my domain?

This can happen when you had a wildcard `*` record configured at your previous authoritative DNS, and for some reason the wildcard record wasn't detected. You can remove these records in bulk [using the API](https://developers.cloudflare.com/api/resources/dns/subresources/records/methods/delete/).

Alternatively, you can also:

1. [Remove your domain](https://developers.cloudflare.com/fundamentals/manage-domains/remove-domain/) from Cloudflare.
2. Delete the wildcard record from your authoritative DNS.
3. [Re-add](https://developers.cloudflare.com/fundamentals/manage-domains/add-site/) the domain.

***

## What IP should I use for parked domain / redirect-only / originless setup?

In the case a placeholder address is needed for “originless” setups, use the IPv6 reserved address `100::` or the IPv4 reserved address `192.0.2.0` in your Cloudflare DNS to create a [proxied DNS record](https://developers.cloudflare.com/dns/proxy-status/) that can use Cloudflare [Redirect Rules](https://developers.cloudflare.com/rules/url-forwarding/), [Page Rules](https://developers.cloudflare.com/rules/page-rules/), or [Cloudflare Workers](https://developers.cloudflare.com/workers/).

***

## Why are DNS queries returning incorrect results?

Third-party tools can sometimes fail to return correct DNS results if a recursive DNS cache fails to refresh. In this circumstance, purge your public DNS cache via these methods:

* [Purging your DNS cache at OpenDNS](http://www.opendns.com/support/cache/)
* [Purging your DNS cache at Google](https://developers.google.com/speed/public-dns/cache)
* [Purging your DNS cache locally](https://docs.cpanel.net/knowledge-base/dns/how-to-clear-your-dns-cache/)

***

## Why have I received an email: Your Name Servers have Changed?

For domains where Cloudflare hosts the DNS, Cloudflare continuously checks whether the domain uses Cloudflare’s nameservers for DNS resolution. If Cloudflare's nameservers are not used, the [domain status](https://developers.cloudflare.com/dns/zone-setups/reference/domain-status/) is updated from *Active* to *Moved* in the Cloudflare **Overview** app and an email is sent to the customer.

This is important because, if a domain is in a *Moved* state for a [long enough period of time](https://developers.cloudflare.com/dns/zone-setups/reference/domain-status/), it will be deleted from Cloudflare.

To recover a deleted domain, [re-add it in Cloudflare](https://developers.cloudflare.com/fundamentals/manage-domains/add-site/) just like you would for a new domain.

Warning

Cloudflare support is unable to restore DNS or settings for deleted domains.

***

## Why am I getting a warning for hostname not covered even if I have a custom certificate?

If the [custom certificate](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/) has been in place before our new certificate management pipeline, the following warning is displayed but can be discarded. `This hostname is not covered by a certificate.`

The warning will be gone when you upload a new custom certificate, or start using another type of certificate for this hostname.

***

## I've updated my CNAME to a new SaaS provider, but I still see content from the old provider

When a SaaS provider is leveraging our [Cloudflare for SaaS](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/) solution, they create a [Custom Hostname](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/domain-support/) on their Cloudflare zone. Then a [CNAME record needs to be created](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/saas-customers/how-it-works/) on the client zone, to point to the SaaS provider service. When changing SaaS providers, if the old SaaS provider provisioned a specific custom hostname for the record (`mystore.example.com`) and the new SaaS provider provisioned a wildcard custom hostname (`*.example.com`), the old custom hostname will still take precedence. This is expected as per the [Certificate and hostname priority](https://developers.cloudflare.com/ssl/reference/certificate-and-hostname-priority/#hostname-priority).

In this case there are 2 ways forward:

* (*Recommended*) Ask the new SaaS provider to provision a specific custom hostname for you instead of the wildcard (`mystore.example.com` instead of `*.example.com`).
* Ask the Super Administrator of your account to contact [Cloudflare Support](https://developers.cloudflare.com/support/contacting-cloudflare-support/) to request an update of the SaaS configuration.
