---
title: Run endpoint health checks (beta) · Cloudflare Magic Transit docs
description: Magic Transit uses endpoint health checks to determine the overall
  health of your inter-network connections. Probes originate from Cloudflare
  infrastructure, outside customer network namespaces, and target IP addresses
  deep within your network, beyond the tunnel-terminating border router. These
  "long distance" probes are purely diagnostic.
lastUpdated: 2025-09-08T16:19:34.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-transit/network-health/run-endpoint-health-checks/
  md: https://developers.cloudflare.com/magic-transit/network-health/run-endpoint-health-checks/index.md
---

Magic Transit uses endpoint health checks to determine the overall health of your [inter-network connections](https://developers.cloudflare.com/magic-transit/reference/gre-ipsec-tunnels/). Probes originate from Cloudflare infrastructure, outside customer network namespaces, and target IP addresses deep within your network, beyond the tunnel-terminating border router. These "long distance" probes are purely diagnostic.

When choosing which endpoint IP addresses to monitor with health checks, use these guidelines:

* Provide one IP address for each of the prefixes Cloudflare will advertise.
* Redundant IPs routed via the same ISP and infrastructure are not necessary but are useful when troubleshooting.

Cloudflare pings health check IPs from within the [published Cloudflare IP range](https://www.cloudflare.com/ips/), which is also available via the [Cloudflare API](https://developers.cloudflare.com/api/resources/ips/methods/list/).

When configuring an endpoint health check for an IP prefix, you need to select an IP address that is within the range of that IP prefix. Refer to the table below for an example of an endpoint health check configuration.

| Prefix | Endpoint IP address |
| - | - |
| `103.21.244.0/24` | `103.21.244.100` |
| `103.21.245.0/24` | `103.21.245.100` |

Refer to [Tunnel health checks](https://developers.cloudflare.com/magic-transit/reference/tunnel-health-checks/) for more information on this topic.

## Configure endpoint health checks (beta)

Endpoint health checks can only be configured via the Cloudflare API. Endpoint health checks can not be configured via the dashboard, and they are not shown in the dashboard. Currently, configuring health checks is a beta feature.

Refer to the [API documentation](https://developers.cloudflare.com/api/resources/diagnostics/subresources/endpoint-healthchecks/) to learn how to create, list, and delete endpoint health checks. Here is an example of an API request which sends a request to the Cloudflare API to create a new endpoint health check.

Note

You will need your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and [API Key](https://developers.cloudflare.com/fundamentals/api/get-started/keys/#view-your-global-api-key) to use the API.

```bash
curl "https://api.cloudflare.com/client/v4/accounts/account_id/diagnostics/endpoint-healthcheck" \
  --request POST \
  --json '{
    "check_type": "icmp",
    "endpoint": "8.31.160.1"
  }'
```

```json
{
    "result": {
        "id": "<HEALTH_CHECK_ID>",
        "check_type": "icmp",
        "endpoint": "8.31.160.1"
    },
    "success": true,
    "errors": [],
    "messages": []
}
```

## Query GraphQL endpoint health checks

You can also use GraphQL to query endpoints within your network. This allows you to know if an IP within your network is reachable, and also set alerts in case there is a problem.

You can query the following categories:

* `checkId`: The ID of the check associated with the health check.
* `checkType`: The type of check associated with the health check.
* `date`: The health check event timestamp truncated to the day.
* `datetime`: The health check event timestamp.
* `datetimeFifteenMinutes`: The health check event timestamp truncated to multiples of 15 minutes.
* `datetimeFiveMinutes`: The health check event timestamp truncated to multiples of five minutes.
* `datetimeHalfOfHour`: The health check event timestamp truncated to multiples of 30 minutes.
* `datetimeHour`: The health check event timestamp truncated to the hour.
* `datetimeMinute`: The health check event timestamp truncated to the minute.
* `endpoint`: The endpoint of the check associated with the health check.

Refer to the example below on how to create a query to check your endpoint's health:

```graphql
query Viewer {
    viewer {
        accounts(filter: { accountTag: "YOUR_ACCOUNT_TAG" }) {
            magicEndpointHealthCheckAdaptiveGroups(
                filter: { date_geq: "2025-05-10" }
                limit: 10
            ) {
                count
                dimensions {
                    checkId
                    checkType
                    date
                    datetime
                    datetimeFifteenMinutes
                    datetimeFiveMinutes
                    datetimeHalfOfHour
                    datetimeHour
                    datetimeMinute
                    endpoint
                }
                sum {
                    failures
                    total
                }
            }
        }
    }
}
```

## Configure alerts for endpoint health checks

You can set up alerts to be notified when the state of your endpoint's health is below a threshold defined by you.

1. Make a `GET` request to get a list of IDs for all of the endpoint health checks configured:

```bash
curl "https://api.cloudflare.com/client/v4/accounts/%3Caccount%20id%3E/diagnostics/endpoint-healthcheck" \
  --request GET
```

```json
{
    "result": [
        {
            "id": "<HEALTH_CHECK_ID>",
            "check_type": "icmp",
            "endpoint": "8.31.160.1"
        }
    ],
    "success": true,
    "errors": [],
    "messages": []
}
```

1. Take note of the `id` value for the endpoint you want to get alerts for.
2. In the Cloudflare dash, go to the **Notifications** page.

[Go to **Notifications**](https://dash.cloudflare.com/?to=/:account/notifications)

1. Select **Add**.

2. From the drop down menu, select *Magic Transit*.

3. Select **Magic Endpoint Health Check Alert**.

4. Provide a name for your new notification and optionally provide a description.

5. In the *Service Level Objective (SLO)* dropdown, select the SLO threshold for your notification. The SLO defines the percentage of endpoint health checks that should be passing. If the number of endpoint health checks passing is less than the SLO, an alert is generated:

   * **High** - 99% of endpoint health checks
   * **Medium** - 98% of endpoint health checks
   * **Low** - 97% of endpoint health checks

6. In the dropdown menu below SLOs, select the `id` value that matches the `id` you got through the API in step one. This `id` should match the endpoint health check you want to get notifications for.

7. Select your preferred notification method (like email or Webhooks).

8. Select **Save**.

You will now receive notifications via your preferred method whenever the SLO for your endpoint health checks falls below your chosen threshold.
