---
title: Error 409 · Cloudflare Support docs
description: The 409 Conflict status code indicates that the request could not
  be completed due to a conflict with the current state of the target resource.
lastUpdated: 2025-05-21T17:09:12.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/4xx-client-error/error-409/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/4xx-client-error/error-409/index.md
---

## 409 Conflict

The `409 Conflict` status code indicates that the request could not be completed due to a conflict with the current state of the target resource.

For more details, refer to [RFC 7231](https://tools.ietf.org/html/rfc7231).

### Common use cases

This error typically happens with a `PUT` request when multiple clients are attempting to edit the same resource. To solve this issue:

* The server should generate a payload that includes enough information for the client to recognize the source of the conflict.
* Clients should retry the request again after resolving the conflict.

### Cloudflare-specific information

Cloudflare will return a 409 response for a [Error 1001: DNS Resolution Error](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1001/).
